<?php defined('SYSPATH') or die('No direct script access.');

class Model_Insert_Blacklist extends ORM {
	protected $_primary_key = 'id';
	protected $_table_name = 'insert_blacklist';
	protected $_table_columns = array(
		'id' => NULL,
		'data' => NULL,
        'modifier' => NULL,
        'type' => NULL,
	);

    public static function checkBlackList($subject, $type){
        if(empty($subject)){
            return true;
        }

        $blacklist = DB::select()
            ->from(ORM::factory('Insert_Blacklist')->table_name())
            ->where('type', '=', $type)
            ->execute();
        $ifNotInBlackList = true;
        foreach($blacklist as $item){
            $delimiter = '#';
            if(preg_match($delimiter.$item['data'].$delimiter.$item['modifier'], $subject)) {
                $ifNotInBlackList = false;
                break;
            }
        }
        return $ifNotInBlackList;
    }
}
